#!/bin/bash
#
# nis.sh: dhclient-script plugin for NIS settings,
#         place in /etc/dhcp/dhclient.d and 'chmod +x nis.sh' to enable
#
# Copyright (C) 2008 Red Hat, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Author(s): David Cantrell <dcantrell@redhat.com>
#

CONF=/etc/yp.conf

fixContext() {
    if [ -x /sbin/restorecon ]; then
        /sbin/restorecon ${1} >/dev/null 2>&1
    fi
}

save_config_file() {
    origfile="${1}"
    savefile="${SAVEDIR}/${origfile##*/}.predhclient.${interface}"

    if [ ! -d ${SAVEDIR} ]; then
        mkdir -p ${SAVEDIR}
    fi

    if [ -e ${origfile} ]; then
        mv ${origfile} ${savefile}
    else
        echo > ${savefile}
    fi

    fixContext ${savefile}
}

nis_config() {
    if [ ! "${PEERNIS}" = "no" ]; then
        if [ -n "${new_nis_domain}" ]; then
            domainname "${new_nis_domain}"
            save_config_file ${CONF}
            let contents=0
            echo '# generated by /sbin/dhclient-script' > ${CONF}

            if [ -n "${new_nis_servers}" ]; then
                for i in ${new_nis_servers} ; do
                    echo "domain ${new_nis_domain} server ${i}" >> ${CONF}
                    let contents=contents+1
                done
            else
                echo "domain ${new_nis_domain} broadcast" >> ${CONF}
                let contents=contents+1
            fi

            if [ ${contents} -gt 0 ]; then
                if [ -x /etc/rc.d/init.d/ypbind ] &&
                   [ -r /var/run/ypbind.pid ]; then
                    service ypbind restart >/dev/null 2>&1
                fi
            fi
        elif [ -n "${new_nis_servers}" ]; then
            save_config_file ${CONF}
            echo '# generated by /sbin/dhclient-script' > ${CONF}
            let contents=0

            for i in ${new_nis_servers} ; do
                echo "ypserver ${i}" >> ${CONF}
                let contents=contents+1
            done

            if [ $contents -gt 0 ]; then
                if [ -x /etc/rc.d/init.d/ypbind ] &&
                   [ -r /var/run/ypbind.pid ]; then
                    service ypbind restart >/dev/null 2>&1
                fi
            fi
        fi
    fi
}

nis_restore() {
    if [ ! "${PEERNIS}" = "no" ]; then
        if [ -f ${SAVEDIR}/${CONF}.predhclient.${interface} ]; then
            rm -f ${CONF}
            mv -f ${SAVEDIR}/${CONF}.predhclient.${interface} ${CONF}
            fixContext /etc/yp.conf
            if [ -x /etc/rc.d/init.d/ypbind ] && [ -r /var/run/ypbind.pid ]; then
                service ypbind restart >/dev/null 2>&1
            fi
        fi
    fi
}
